﻿/*
VERSION:		1.0
	
WHAT THIS IS FOR:
	This allows you to type convenient codes in a text string,
	and have a textfield render the effects via HTML.
	It replaces the codes you type with HTML codes.
	It returns the string, HTML formatted for display.
	
USAGE:
	output_txt.htmlText = makeHtml("hello\n[r]there");
	
CODES:
	[l]		left alignment
	[m]	middle alignment
	[r]		right alignment
	[#rrggbb]	color

NOTE:
	I don't want to worry about closing tags.
	(related tags close previous tags)
*/
_global.makeHtml = function( myText )
{
	// filter reserved HTML symbols
	// &		&amp;
	var startAt = 0;
	while( myText.indexOf( "&", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "&", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+1);
		// replace the symbol
		myText = start_txt+"&amp;"+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 5;
	}// while:  & are detected
	
	// <		&lt;
	var startAt = 0;
	while( myText.indexOf( "<", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "<", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+1);
		// replace the symbol
		myText = start_txt+"&lt;"+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 4;
	}// while:  < are detected
	
	// >		&gt;
	var startAt = 0;
	while( myText.indexOf( ">", startAt) != -1 )
	{
		var changeAt = myText.indexOf( ">", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+1);
		// replace the symbol
		myText = start_txt+"&gt;"+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 4;
	}// while:  > are detected
	
	// "		&quot;
	var startAt = 0;
	while( myText.indexOf( '"', startAt) != -1 )
	{
		var changeAt = myText.indexOf( '"', startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+1);
		// replace the symbol
		myText = start_txt+"&quot;"+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 6;
	}// while:  " are detected
	
	// '		&apos;
	var startAt = 0;
	while( myText.indexOf( "'", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "'", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+1);
		// replace the symbol
		myText = start_txt+"&apos;"+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 6;
	}// while:  ' are detected
	
	
	
	// filter shortcut codes
	// [l]
	var startAt = 0;
	while( myText.indexOf( "[l]", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "[l]", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+3);
		// replace the symbol
		myText = start_txt+'<p align="left">'+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 16;
	}// while:  [l] are detected
	
	// [m]
	var startAt = 0;
	while( myText.indexOf( "[m]", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "[m]", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+3);
		// replace the symbol
		myText = start_txt+'<p align="center">'+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 18;
	}// while:  [m] are detected
	
	// [r]
	var startAt = 0;
	while( myText.indexOf( "[r]", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "[r]", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+3);
		// replace the symbol
		myText = start_txt+'<p align="right">'+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 17;
	}// while:  [r] are detected
	
	// [#ff0000]
	var startAt = 0;
	while( myText.indexOf( "[#", startAt) != -1 )
	{
		var changeAt = myText.indexOf( "[#", startAt);
		var start_txt = myText.slice(0, changeAt);
		var end_txt = myText.slice(changeAt+9);
		var color = myText.slice(changeAt+2, changeAt+8);
		// replace the symbol
		myText = start_txt+'<font color="#'+color+'">'+end_txt;
		// offset past the inserted code
		startAt = changeAt;
		startAt += 17;
	}// while:  [#ff0000] are detected
	
	return myText;
}// makeHtml()